
**************************************************************************************************************************************************
******************* Code for 'Doing Less with Less: Capital Misallocation, investment and the prodcutivty slowdown in Australia *******************
***************************************************** Code for summary tables and macro est******************************************************************

**************************************************DATE: AUG 2022 ******************************************************************************
**************************************************** AUTHOR: Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************



*** Code strcuture
*00. Preliminaries and globals
*01. Tables
*02 Macro est

*00. Preliminaries and globals
global reg m_DLW_tl_m_w_y

clear
use save "$outputs\reg_file.dta", replace
****** 03  - Markup changes by fin dependence



********** 01 Tables 
	
	**Summari stats Table A1
	preserve
		keep if d_k_bound!=. & dev_prod_MFP!=. & demean_unemp_state!=. & size !=. & young!=. & dev_prod_MFP>dev_prod_MFP1 & dev_prod_MFP< dev_prod_MFP99  & fyear>2005
		collapse(mean) Y_nom age fte d_k_bound i_k (median) med_Y_nom=Y_nom med_age=age med_fte=fte med_d_k_bound=d_k_bound med_i_k=i_k  (sum) young (count) firmid
		export delimited using "$regs\table_A1.csv", replace 
	restore		
	
** Table A2	
preserve
		keep if d_k_bound!=. & dev_prod_MFP!=. & demean_unemp_state!=. & size !=. & young!=. & dev_prod_MFP>dev_prod_MFP1 & dev_prod_MFP< dev_prod_MFP99  & fyear>2005
		collapse(count) firmid ,by(size q_dev_prod_MFP)
		export delimited using "$regs\Table A2.csv", replace 
restore




********** 02 Macro ests


** REmove sectors excluding for this excercise 
preserve
drop if division == "A" |  division == "B" | division == "D"

** Can do for dif period deifnition or mark-ups if wanted here using preiod2 or mi_$reg
foreach meas in period1   {

** define variable to cary
if "`meas'" == "mi_$reg" {
	local name mi
	local vars c.l.`meas'
}

if "`meas'" == "period1" {
	local name per1
	local vars i.`meas'

}

if "`meas'" == "period2" {
	local name per2
	local vars i.`meas'

}

** seting varaible to 2004 value
bysort industry (fyear): g `name'_p_first = `meas' if fyear == 2004
bysort industry : egen `name'_p_first1 = min(`name'_p_first)
xtset firmid fyear

**** Run itnial estiamtions to define sample
areg d_k_bound c.l.dev_prod_MFP##`vars'  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP <dev_prod_MFP99 & fyear>2005, a(ind_yr) vce(cluster industry)
g sample_k = (e(sample)==1)
areg dfte c.l.dev_prod_MFP##`vars'  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP <dev_prod_MFP99 & fyear>2005, a(ind_yr) vce(cluster industry)	
g sample_l = (e(sample)==1)


*********************** Now do the regressions to get parameters etc
******* K version 

** Baseline reg
areg d_k_bound c.l.dev_prod_MFP##`vars'  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP <dev_prod_MFP99 & sample_k==1 & sample_l==1 & fyear>2005, a(ind_yr) vce(cluster industry)	
predict K_p_`name'_ if e(sample)==1

* Make alternate measure
g  `meas'_p_alt_k = `meas' // alt measure

areg d_k_bound c.l.dev_prod_MFP c.l.dev_prod_MFP#`vars'_p_alt_k  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & sample_k==1 & sample_l==1 & fyear>2005, a(ind_yr) vce(cluster industry)	

*replace alternate measure with what using to stay uncahgned
replace `meas'_p_alt_k= `name'_p_first1

* Predic based on uncahnged version of that metric
xtset firmid fyear
predict K_p_`name'_alt if e(sample)==1


******* L version 
areg dfte c.l.dev_prod_MFP##`vars'  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP <dev_prod_MFP99 & sample_k==1 & sample_l==1 & fyear>2005, a(ind_yr) vce(cluster industry)	
predict fte_p_`name'_ if e(sample)==1


g  `meas'_p_alt_fte = `meas' // alt measure

areg dfte c.l.dev_prod_MFP c.l.dev_prod_MFP#`vars'_p_alt_fte  c.l.dev_prod_MFP##c.demean_unemp_state i.State##i.fyear i.size dlgo i.young if l.dev_prod_MFP>dev_prod_MFP1 & l.dev_prod_MFP < dev_prod_MFP99 & sample_k==1 & sample_l==1 & fyear>2005, a(ind_yr) vce(cluster industry)	

replace `meas'_p_alt_fte= `name'_p_first1

xtset firmid fyear
predict fte_p_`name'_alt if e(sample)==1

******* Now do the predictions using the main and alterante metrics (i.e. allowing change and not)
foreach var in _ _alt {

	g k_p_`name'`var'_lvl = log((l.K+K_p_`name'`var'/2*l.K)/(1-K_p_`name'`var'/2)) // alternate k
	g fte_p_`name'`var'_lvl = log((l.fte+fte_p_`name'`var'/2*l.fte)/(1-fte_p_`name'`var'/2)) // alternate l
** version with TFP in it

	** Composite input index - based on TL prod func. If change MFP metric need cahnge prod func
	g yntfp_`name'`var' = l1_dlw_tl_w_y*fte_p_`name'`var'_lvl+k1_dlw_tl_w_y*k_p_`name'`var'_lvl+m1_dlw_tl_w_y*m+l2_dlw_tl_w_y*fte_p_`name'`var'_lvl^2+k2_dlw_tl_w_y*k_p_`name'`var'_lvl^2+m2_dlw_tl_w_y*m^2+l1k1_dlw_tl_w_y*fte_p_`name'`var'_lvl*k_p_`name'`var'_lvl+l1m1_dlw_tl_w_y*fte_p_`name'`var'_lvl*m+m1k1_dlw_tl_w_y*m*k_p_`name'`var'_lvl
	g yntfp_`name'`var'_exp = exp(yntfp_`name'`var') // exponentialise
	bysort fyear : egen yntfp_`name'`var'_exp_tot = sum(yntfp_`name'`var'_exp) // total inuputs

	g yntfp_`name'`var'_exp_sh = yntfp_`name'`var'_exp/yntfp_`name'`var'_exp_tot // firm share
	xtset firmid fyear
	g w_prod_nmfp_exp`var'_`name' = yntfp_`name'`var'_exp_sh*l.exp_prod_DLW_tl_w_y // weighred
}

drop sample_l sample_k
}

collapse(sum)   w_prod_nmfp_exp_* , by(fyear) // will produce base and alterate indicies of prodcutivity. % gap between altrante and base is how much higher prodcutivity would have been (or growth i nthe year), without the slowdown
export delimited "$regs\Realloc_series_full.csv", replace  
	restore 
	
	
****** 03  - Markup changes by fin dependence
clear 	
use "$outputs\sum_k_`k_meas'_instr_`k_instr'_out_`output'_int_`input'_trm_`trim'_`ind'_`file'_l`cuts'.dta", clear

merge m:1 industry using "P:\mANIP DATA\rajan_zing.dta", keep(master match)

eststo clear 
xtset industry fyear
eststo: xtreg mi_$reg i.fyear##i.q_FINDEPRZ if division!="A" & division !="B" & division !="D", fe
eststo: xtreg mi_$reg i.fyear if division!="A" & division !="B" & division !="D" & q_FINDEPRZ==4, fe
eststo: xtreg mi_$reg i.fyear if division!="A" & division !="B" & division !="D" & q_FINDEPRZ!=4, fe


esttab using "$regs\figure_B1.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace
	eststo  clear
